#include "ShaderConstants.fxh"
#include "util.fxh"

struct PS_Input
{
    float4 position : SV_Position;
    float2 uv : TEXCOORD_0_FB_MSAA;
    float3 posi : POSI;
    float4 wpos : WPOS;

};

struct PS_Output
{
    float4 color : SV_Target;
};

#include "dect.fxh"

float3 lens(float2 u, float2 w)
{
    float2 uvd = u * length(u);
    float f2 = max(1.960 / (1.0 + 32.120 * pow(length(uvd + 1.464 * w), 1.696)), 0.0) * 0.458;
    float2 uvx = lerp(u, uvd, - 1.108);
    float f4 = max(0.032 - pow(length(uvx + 0.586 * w), 2.992), 0.0) * 5.464;
    uvx = lerp(u, uvd, -1.760);
    float f5 = max(0.002 - pow(length(uvx + 1.660 * w), 5.5), 0.0) * 6.208;
    uvx = lerp(u, uvd, -0.588);
    float f6 = max(0.058 - pow(length(uvx + 1.540 * w), 1.096), 0.000) * 9.912;
    float3 c = float3(0.0,0.0,0.0);
    float l = f2 + f4 + f5 + f6; 
    c += float3(l,l,l);
    return c * 0.580;
}

float sun(float3 po)
{
    float c = 1.0;
    float l = 1.0;
    float3 uvs = po;
    float3 p = po;
    l = length(p);
	uvs -= smoothstep(1.0, 0.0, p / l * - 0.474);
    uvs += smoothstep(1.0, 0.0, p / l * 0.474);
    c = 0.01 / length(abs(frac(uvs) - 0.5));
    return c * 1.704 / l;

}

float ray(float3 po, float v)
{
    float c = 1.0;
    float l = 1.0;
    float3 uvs = po;
    float3 p = po;
    l = length(p);
    uvs -= smoothstep(1.0, -0.864, p / l * -0.574);
    uvs += smoothstep(1.0, -0.864, p / l * 0.574);
    uvs *= l - 4.024 + sin(l / - 1.728);
    c = 0.04 / length(abs(frac(uvs) - 0.5));
    return c * v / l;
}

ROOT_SIGNATURE
void main(in PS_Input PSInput, out PS_Output PSOutput)
{

#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE) || (VERSION < 0xa000 /*D3D_FEATURE_LEVEL_10_0*/) 
	float4 diffuse = TEXTURE_0.Sample(TextureSampler0, PSInput.uv);
#else
	float4 diffuse = texture2D_AA(TEXTURE_0, TextureSampler0, PSInput.uv);
#endif

	float4 temp = TEXTURE_1.Sample(TextureSampler1, float2(0.0, 1.0));
    float chuva = Rain(FOG_CONTROL);
    float dia = max(0.0, min( 1.0, (temp.r - 0.48) * 2.0));
    float noite =  lerp(0.0,5.0,pow(max(min(1.0-temp.r*1.5,1.0),0.0),1.2));
    float dsol = lerp(lerp( 0.0, 5.0, clamp((1.-dia*(1.5+chuva))*2.5, .0, 1.)*clamp((temp.r -.15)*1.0,0.,1.)),0.5,noite);
    
    float3 posii = PSInput.posi.xyz;
    float3 c = float3(0.0,0.0,0.0);
    float2 w = -PSInput.wpos.xy * 0.2;

    float lu = abs(lerp(lerp(sun(posii), ray(posii, 1.080) * dia, 0.100), smoothstep(5.0, -5.0, length(posii) * 6.0), 0.5));
    float3 cs = lerp(lerp(float3(0.990,0.890,0.724), float3(0.990,0.923,1.0), noite), float3(0.990,0.923,0.724) + FOG_COLOR.rgb, dsol);
    c = lerp(float3(0.0,0.0,0.0), cs, lu);
    c += lens(posii.xz, w) * dia;
    c = lerp(c, float3(0.0,0.0,0.0), smoothstep(0.0, 1.0, length(posii) * 1.8));    
    float4 dif = float4(c, 1.0);
              dif.a *= lerp(1.0, 0.0, chuva);

#ifdef IGNORE_CURRENTCOLOR
    PSOutput.color =  dif;
#else
    PSOutput.color =  dif;
#endif

#ifdef WINDOWSMR_MAGICALPHA
    // Set the magic MR value alpha value so that this content pops over layers
    PSOutput.color.a = 133.0f / 255.0f;
#endif
}
